import asyncio
from fastmcp import Client
import json

########### Connect to a local MCP server ###########
http_server1 = "http://localhost:8000/mcp"
client1 = Client(http_server1)
print("--> Connected to MCP server at: " + http_server1)

async def call_tools(city, state, cuisine):
    async with client1:
        result1 = await client1.call_tool("get_restaurants_for_location_cuisine",
                                         {"city": city, "state": state, "cuisine": cuisine})
        candidates = json.loads(result1.content[0].text)

        print(f"Found {len(candidates)} candidate restaurants.")
        if candidates:
            print("Here is the first restaurant:")
            first = candidates[0]
            print(first)
            result2 = await client1.call_tool("is_restaurant_kid_friendly",
                                             {"name": first["name"],
                                              "full_address": (first["street_address"], first["city"], first["state"])})
            print(f"{first["name"]} is " + ("" if result2.content else "not ") + "kid friendly.")

asyncio.run(call_tools("Philadelphia", "PA", "Thai"))


########### Connect to a remote MCP server ###########

http_server2 = "https://mcp.deepwiki.com/sse"
client2 = Client(http_server2)
print("--> Connected to MCP server at: " + http_server2)

async def main():
    async with client2:
        # Basic server interaction.
        await client2.ping()

        # List available tools.
        tools = await client2.list_tools()
        for tool in tools:
            print(tool)

asyncio.run(main())
