import json

BUSINESS_PATH = '../data/business.json'
REVIEWS_PATH = '../data/review.json'

# Load business info from JSON database.
businesses =  json.load(open(BUSINESS_PATH))

def create_l2b(businesses):
    # Create the `l2b` table that maps a tuple (city, state)
    # to a list of restaurants at that location.
    l2b = {}
    for b in businesses:
        city = b["city"]
        state = b["state"]
        location = (city, state)
        if location in l2b:
            l2b[location].append(b)
        else:
            l2b[location] = [b]

    return l2b


# Create the location -> businesses dictionary.
l2b = create_l2b(businesses)


################## FastMCP Server Tools ####################

from fastmcp import FastMCP

mcp = FastMCP("My MCP Restaurant Server")

@mcp.tool
def get_restaurants_for_location_cuisine(city: str, state: str, cuisine: str) -> list:
    """Gets a list of restaurants that are located at a particular location (city and state) and serve a particular cuisine.
    """
    candidates = l2b[(city, state)]
    results = []
    for rest in candidates:
        if cuisine.lower() in rest["categories"].lower():
            result = {
                "name": rest["name"],
                "city": city,
                "state": state,
                "street_address": rest["address"],
                "postal_code": rest["postal_code"]
                }
            results.append(result)

    print("Total restaurants found: " + str(len(results))) # This will be printed on the server side.
    
    return results


@mcp.tool
def is_restaurant_kid_friendly(name, full_address):
    """Returns True if a restaurant is kid friendly, False otherwise.
    """
    street_address, city, state = full_address
    candidates = l2b[(city, state)]
    for rest in candidates:
        if rest["name"] == name and rest["address"] == street_address:
            return rest["attributes"]["GoodForKids"] == "True"




if __name__ == "__main__":
    mcp.run()
