import re

def clean_json_block(raw: str) -> str:
    """
    Clean the contents of a JSON block that may come wrapped with Markdown backticks.
    """
    raw = raw.strip()
    # Quitar bloque tipo ```json ... ```
    if raw.startswith("```"):
        raw = re.sub(r"^```(?:json)?\n?", "", raw)
        raw = re.sub(r"\n?```$", "", raw)
    return raw.strip()

def clean_markdown_block(raw: str) -> str:
    """
    Clean the contents of a JSON block that may come wrapped with Markdown backticks.
    """
    raw = raw.strip()
    # Quitar bloque tipo ```markdown ... ```
    if raw.startswith("```"):
        raw = re.sub(r"^```(?:markdown)?\n?", "", raw)
        raw = re.sub(r"\n?```$", "", raw)
    return raw.strip()
